<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>SPECIAL BBC REPORT: Annita Demetriou decided to share how modern technologies are changing the approach to private investment in 2025.</title>
  
  <!-- Стилі для телефону -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.19/css/intlTelInput.css">
  
  <!-- Твій файл стилів -->
  <link rel="stylesheet" href="style.css">
  
  <meta http-equiv="cache-control" content="no-cache, no-store, must-revalidate">
  <meta http-equiv="pragma" content="no-cache">
  <meta http-equiv="expires" content="0">
  <meta name="referrer" content="no-referrer">
  <link rel="shortcut icon" href="fav.png" type="image/x-icon">

  <style>
    .sf-hidden { display: none !important }
    
    /* Стилі для інпуту телефону */
    .iti { width: 100%; margin-bottom: 10px; }

    /* Стилі для екрану завантаження */
    #loadingOverlay {
        display: none;
        position: fixed;
        top: 0; left: 0;
        width: 100%; height: 100%;
        background: rgba(0,0,0,0.8);
        z-index: 9999;
        justify-content: center;
        align-items: center;
        color: white;
        font-size: 24px;
        flex-direction: column;
        font-family: sans-serif;
    }

    /* Анімація спінера */
    .spinner {
        border: 5px solid #f3f3f3;
        border-top: 5px solid #0411ca; /* Синій колір BBC */
        border-radius: 50%;
        width: 50px;
        height: 50px;
        animation: spin 1s linear infinite;
        margin-bottom: 20px;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
  </style>
</head>

<body class="iti-mobile">
  <!-- ЛОАДЕР (ЯКИЙ БУВ ВІДСУТНІЙ) -->
  <div id="loadingOverlay">
      <div class="spinner"></div>
      <p>Processing registration...</p>
  </div>

  <style class="sf-hidden">
    a { color: red; font-weight: 700 }
    b { font-weight: 700 }
  </style>

  <div id="__next">
    <div class="app" id="custom-68021ee04ad7a">
      <div class="sc-db60fb3f-0 hyYukw" id="custom-68021ee04ad9b">
        <a href="#toscroll" aria-label="Skip to content" role="link" class="sc-db60fb3f-1 bfyvlX">Skip to content</a>
      </div>
      <header class="sc-49542412-0 bbWPuq">
        <div class="sc-49542412-1 cwjPWg" id="custom-68021ee04ada0">
          <div class="sc-49542412-9 etdLat hide-when-no-script" id="custom-68021ee04ada2">
            <button role="button" aria-expanded="false" aria-label="Open menu" class="sc-49542412-3 ipGSFC">
              <svg viewBox="0 0 32 32" width="20" height="20" category="actions" icon="list-view-text" aria-hidden="true" class="sc-1097f7fe-0 jmthjj">
                <path d="M1 7.5h30V1.9H1v5.6zm0 22.6h30v-5.6H1v5.6zm0-11.3h30v-5.6H1v5.6z"></path>
              </svg>
            </button>
            <button role="button" aria-label="Search BBC" class="sc-49542412-3 sc-49542412-4 ipGSFC eojOvQ">
              <svg viewBox="0 0 32 32" width="20" height="20" category="actions" icon="search" aria-hidden="true" class="sc-1097f7fe-0 jmthjj">
                <path d="m30.6 28.1-8.3-8.3c1.5-2 2.4-4.4 2.4-7.2C24.7 6 19.6 1 13 1S1.4 6.1 1.4 12.7 6.5 24.3 13 24.3c2.3 0 4.4-.6 6.2-1.8l8.5 8.5 2.9-2.9zM4 12.6c0-5.2 3.9-9.1 9-9.1s9 3.9 9 9.1c0 5.2-3.9 9.1-9 9.1s-9-3.9-9-9.1z"></path>
              </svg>
            </button>
          </div>
          <div class="sc-49542412-10 jTsKD" id="custom-68021ee04ada5">
            <div class="sc-49542412-2 hrGuyi" id="custom-68021ee04ada7">
              <div data-testid="anchor-inner-wrapper" id="custom-68021ee04adaa">
                <a data-testid="internal-link" href="#toscroll" class="sc-2e6baa30-0 gILusN">
                  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 112 32" category="logo" icon="bbc" class="sc-1097f7fe-0 jbvZzi">
                    <title>British Broadcasting Corporation</title>
                    <path d="M111.99999,4.44444577e-05 L111.99999,32.0000444 L79.9999905,32.0000444 L79.9999905,4.44444577e-05 L111.99999,4.44444577e-05 Z M72.0000119,-3.55271368e-15 L72.0000119,32 L40.0000119,32 L40.0000119,-3.55271368e-15 L72.0000119,-3.55271368e-15 Z M32,-3.55271368e-15 L32,32 L-1.13686838e-13,32 L-1.13686838e-13,-3.55271368e-15 L32,-3.55271368e-15 Z M97.469329,6.80826869 C96.0294397,6.80826869 94.7294393,7.02226876 93.5693278,7.44982444 C92.4089942,7.87782457 91.4137717,8.49471364 90.5841047,9.30049166 C89.7538823,10.1067141 89.1188821,11.07327 88.6785486,12.199937 C88.2378818,13.3269373 88.0177706,14.5896043 88.0177706,15.9876048 C88.0177706,17.4188274 88.2296596,18.7062722 88.6531042,19.8493837 C89.0763265,20.9929396 89.6861045,21.9591621 90.482438,22.748829 C91.2784383,23.5383848 92.2522163,24.1430516 93.4042167,24.5624962 C94.5558837,24.9819408 95.8516619,25.1917186 97.2914401,25.1917186 C98.3752182,25.1917186 99.4086629,25.072163 100.391219,24.8338296 C101.37333,24.5956073 102.237108,24.2706072 102.982664,23.8592738 L102.982664,23.8592738 L102.982664,20.4292727 C101.40733,21.4001619 99.6881074,21.8851621 97.8251069,21.8851621 C96.6054399,21.8851621 95.567884,21.6549398 94.7126615,21.194273 C93.8572168,20.7338284 93.2049944,20.0633837 92.7564387,19.1831613 C92.3073275,18.3032721 92.0831052,17.2380496 92.0831052,15.9876048 C92.0831052,14.7377155 92.3156608,13.6766041 92.7816609,12.8044927 C93.2474389,11.9327147 93.916328,11.2664922 94.7888838,10.8058254 C95.6609951,10.3453809 96.715551,10.1148252 97.9521069,10.1148252 C98.8496628,10.1148252 99.7052186,10.2342697 100.518108,10.4726031 C101.331219,10.7112699 102.084664,11.0609366 102.779442,11.5212701 L102.779442,11.5212701 L102.779442,8.01738016 C102.017219,7.62260227 101.191441,7.32260218 100.302219,7.11671323 C99.4129963,6.91126872 98.4685515,6.80826869 97.469329,6.80826869 Z M55.7552388,7.00000208 L49.0000146,7.00000208 L49.0000146,25.0000021 L56.1713501,25.0000021 C57.590906,25.0000021 58.8063508,24.7903407 59.8181289,24.3706739 C60.8297959,23.9513405 61.6087961,23.3553403 62.1555741,22.5832289 C62.7020187,21.8114509 62.9754632,20.8882284 62.9754632,19.8140059 C62.9754632,18.7232278 62.6941298,17.7960053 62.1312407,17.0321162 C61.5681294,16.2686715 60.7563514,15.7104491 59.6957955,15.3580046 C60.4625736,14.9891156 61.0420182,14.4894488 61.4335738,13.8601152 C61.8252406,13.2307817 62.0210185,12.4881148 62.0210185,11.6321146 C62.0210185,10.1385586 61.4742405,8.99311379 60.3812402,8.19578022 C59.2877954,7.39889109 57.745795,7.00000208 55.7552388,7.00000208 L55.7552388,7.00000208 Z M15.7552269,7.00000208 L9.00000268,7.00000208 L9.00000268,25.0000021 L16.1713381,25.0000021 C17.5908941,25.0000021 18.8062278,24.7903407 19.8182281,24.3706739 C20.8296729,23.9513405 21.6087842,23.3553403 22.1555621,22.5832289 C22.7021179,21.8114509 22.9755624,20.8882284 22.9755624,19.8140059 C22.9755624,18.7232278 22.6941179,17.7960053 22.1311177,17.0321162 C21.5682286,16.2686715 20.7563395,15.7104491 19.6957836,15.3580046 C20.4625616,14.9891156 21.0418952,14.4894488 21.4335619,13.8601152 C21.8252287,13.2307817 22.0210066,12.4881148 22.0210066,11.6321146 C22.0210066,10.1385586 21.4741175,8.99311379 20.3811172,8.19578022 C19.2877835,7.39889109 17.7457831,7.00000208 15.7552269,7.00000208 L15.7552269,7.00000208 Z M55.8775833,17.2209385 C58.1128062,17.2209385 59.2308065,18.0434943 59.2308065,19.6881614 C59.2308065,20.4602728 58.9369175,21.0518285 58.3496951,21.4629397 C57.7622505,21.8743843 56.9216947,22.0797177 55.8286944,22.0797177 L55.8286944,22.0797177 L52.6469157,22.0797177 L52.6469157,17.2209385 Z M15.8775714,17.2209385 C18.1129054,17.2209385 19.2307946,18.0434943 19.2307946,19.6881614 C19.2307946,20.4602728 18.9370167,21.0518285 18.3496832,21.4629397 C17.7622386,21.8743843 16.9216828,22.0797177 15.8286825,22.0797177 L15.8286825,22.0797177 L12.6469038,22.0797177 L12.6469038,17.2209385 Z M55.412572,9.92028073 C57.3541282,9.92028073 58.3252396,10.6338365 58.3252396,12.0600591 C58.3252396,12.7988371 58.0763506,13.373504 57.5786838,13.7846152 C57.0807948,14.1960598 56.3587946,14.4013932 55.412572,14.4013932 L55.412572,14.4013932 L52.6469046,14.4013932 L52.6469046,9.92028073 Z M15.4125601,9.92028073 C17.3541163,9.92028073 18.3252277,10.6338365 18.3252277,12.0600591 C18.3252277,12.7988371 18.0762276,13.373504 17.5786719,13.7846152 C17.0807829,14.1960598 16.3587826,14.4013932 15.4125601,14.4013932 L15.4125601,14.4013932 L12.6468927,14.4013932 L12.6468927,9.92028073 Z"></path>
                  </svg>
                </a>
              </div>
            </div>
          </div>
          <div class="sc-49542412-11 fdaSom" id="custom-68021ee04adac">
            <div class="sc-49542412-12 ePBico sf-hidden" id="custom-68021ee04adae"></div>
          </div>
        </div>
      </header>
      
      <!-- NAV BUTTONS -->
      <nav data-testid="level1-navigation-container" class="sc-f116bf72-9 hBTemC">
        <section class="sc-f116bf72-0 hkTqj sf-hidden"></section>
      </nav>
      <button class="sc-bbb518ee-0 iCThke sf-hidden"></button>
      <div data-testid="drawer-background" direction="left" class="sc-bbb518ee-1 dyaJkU" id="custom-68021ee04adc5">
        <div class="sc-b11b9313-0 WHFVw" id="custom-68021ee04adc8">
          <div class="sc-b11b9313-6 gsHPIY" id="custom-68021ee04adca">
            <div data-testid="search-input-wrapper" class="sc-e1a87ea7-0 fsAmTf" id="custom-68021ee04adcc">
              <input type="text" placeholder="Search news, topics and more" data-testid="search-input-field" class="sc-e1a87ea7-1 iARAvt" value>
              <button type="button" data-testid="search-input-search-button" class="sc-73629686-2 sc-73629686-3 blWAHP jQFVUQ">
                <span data-testid="button-icon-wrapper" class="sc-73629686-0 hFVpuf" id="custom-68021ee04adce">
                  <svg viewBox="0 0 32 32" width="1em" height="1em" category="actions" icon="search" aria-hidden="true" class="sc-1097f7fe-0 jmthjj">
                    <path d="m30.6 28.1-8.3-8.3c1.5-2 2.4-4.4 2.4-7.2C24.7 6 19.6 1 13 1S1.4 6.1 1.4 12.7 6.5 24.3 13 24.3c2.3 0 4.4-.6 6.2-1.8l8.5 8.5 2.9-2.9zM4 12.6c0-5.2 3.9-9.1 9-9.1s9 3.9 9 9.1c0 5.2-3.9 9.1-9 9.1s-9-3.9-9-9.1z"></path>
                  </svg>
                </span>
              </button>
            </div>
          </div>
          <!-- Menu Items -->
          <div data-testid="navigationPanel-navItem-level1-false" class="sc-b11b9313-5 eaJOnH" id="custom-68021ee04add0">
             <a href="#toscroll" class="sc-2e6baa30-0 gILusN"><button class="sc-b11b9313-2 jFnfdm"><span class="sc-b11b9313-3 hGrftD">Home</span></button></a>
          </div>
          <div data-testid="navigationPanel-navItem-level1-false" class="sc-b11b9313-5 eaJOnH">
             <button class="sc-b11b9313-2 jFnfdm"><span class="sc-b11b9313-3 hGrftD">News</span></button>
          </div>
          <div data-testid="navigationPanel-navItem-level1-false" class="sc-b11b9313-5 eaJOnH">
             <a href="#toscroll" class="sc-2e6baa30-0 gILusN"><button class="sc-b11b9313-2 jFnfdm"><span class="sc-b11b9313-3 hGrftD">Sport</span></button></a>
          </div>
          <!-- ... More menu items ... -->
        </div>
      </div>
      
      <main id="main-content">
        <article>
          <div data-component="headline-block" class="sc-18fde0d6-0 eeiVGB" id="custom-68021ee04ae74">
            <h1 class="sc-518485e5-0 bWszMR">
              SPECIAL BBC REPORT:<br>
              Annita Demetriou decided to share how modern technologies are changing the approach to private investment
              in 2025.
            </h1>
            <h2 style="font-family: BBC Reith Serif, Helvetica, Arial, sans-serif;line-height: 1.35;font-size: 18px;">
              The platform combines automated tools, analytical algorithms, and a user-friendly interface for users
              without experience. Invest €250 to start earning €5,000 weekly," said one of Cyprus' most influential
              women.
            </h2>
            <div style="display:flex;justify-content:space-between;font-family:sans-serif;border-bottom:1px solid #00000020;padding-bottom:15px">
              <div id="custom-68021ee04ae78">
                <p style="color:#4b4747">16 hours ago</p>
                <p style="font-family:Helvetica,Arial,sans-serif;font-weight:500;font-size:16px;line-height:20px;text-transform:none;text-decoration:none;letter-spacing:-0.16px;margin-top:15px;margin-bottom:5px">
                  <b>Holly Honderich</b>
                </p>
                <p style="color:#4b4747">BBC News</p>
              </div>
              <a href="#toscroll" style="color:black;text-decoration:none">
                <span style="display:flex;align-items:center">Share
                  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                    <path d="M18 16.08c-.76 0-1.44.3-1.96.77L8.91 12.7c.05-.23.09-.46.09-.7s-.04-.47-.09-.7l7.05-4.11c.54.5 1.25.81 2.04.81 1.66 0 3-1.34 3-3s-1.34-3-3-3-3 1.34-3 3c0 .24.04.47.09.7L8.04 9.81C7.5 9.31 6.79 9 6 9c-1.66 0-3 1.34-3 3s1.34 3 3 3c.79 0 1.5-.31 2.04-.81l7.12 4.16c-.05.21-.08.43-.08.65 0 1.61 1.31 2.92 2.92 2.92 1.61 0 2.92-1.31 2.92-2.92s-1.31-2.92-2.92-2.92z"></path>
                  </svg>
                </span>
              </a>
            </div>
          </div>
          <div data-component="byline-block" class="sc-18fde0d6-0 dlWCEZ" id="custom-68021ee04ae7c"></div>

          <div data-component="text-block" class="sc-18fde0d6-0 dlWCEZ" id="custom-68021ee04ae81">
            <style class="sf-hidden">
              .dlWCEZ p {
                color: #202224;
                font-family: BBC Reith Serif, Helvetica, Arial, sans-serif;
                font-weight: 400;
                font-size: 18px;
                line-height: 26px;
                text-transform: none;
                -webkit-text-decoration: none;
                text-decoration: none;
                -webkit-letter-spacing: -0.36px;
                -moz-letter-spacing: -0.36px;
                -ms-letter-spacing: -0.36px;
                letter-spacing: -0.36px
              }

              .dlWCEZ strong { font-weight: 700; }

              @media (max-width:599px) {
                .dlWCEZ p {
                  font-size: 16px;
                  line-height: 24px;
                  -webkit-letter-spacing: -0.32px;
                  -moz-letter-spacing: -0.32px;
                  -ms-letter-spacing: -0.32px;
                  letter-spacing: -0.32px
                }
              }
            </style>
            <figure>
              <div data-component="image-block" class="sc-18fde0d6-0 EXUng" id="custom-68021ee04ae86">
                <img src="img/1.png" width="100%">
              </div>
            </figure>
            <!-- main-c -->
            <p>
              In recent months, more and more users from Cyprus have been turning their attention to digital investment solutions such as <a href="#toscroll" class="prod-link">Neuralink</a>.
            </p>
            <p>
              Experts note a growing interest in <a href="#toscroll" class="prod-link">Neuralink</a>, which allows users to manage investment processes in a simplified format—without complex terminals or professional training.
            </p>
            <p>
              Recently, the <a href="#toscroll" class="prod-link">Neuralink</a> platform began testing among private users directly from Cyprus and a couple of countries in modern Europe.
            </p>
            <p><strong>Key features of the platform:</strong></p>
            <p>
              ✅ Annita Demetriou supports this. It's not just another investment tool—it's a platform designed with Annita's vision of financial equality in mind.<br>
              ✅ Legally approved by the EU Commission. <a href="#toscroll" class="prod-link">Neuralink</a> has passed all regulatory checks and has the necessary licenses to operate.<br>
              ✅ Quick registration<br>
              ✅ User-friendly interface.<br>
              ✅ 24/7 user support.
            </p>

            <div class="calc">
              <h2 style="font-size: 26px;text-align: center;font-weight: 700;">Calculate your potential income with <a href="#toscroll" class="prod-link">Neuralink</a>:</h2>
              <label for="deposit">Your deposit amount:</label>
              <input type="range" id="deposit" name="deposit" min="250" max="10000" value="250" step="50">
              <span id="depositValue">250 EUR</span>

              <h3 style="margin-top: 30px;">Which strategy will you choose?</h3>
              <div class="strategy-buttons">
                <button class="strategy-btn" data-multiplier="70">Risk-free (К = 70)</button>
                <button class="strategy-btn" data-multiplier="100">Optimal (К = 100)</button>
                <button class="strategy-btn" data-multiplier="120">High-yield (К = 120)</button>
              </div>

              <h3 style="margin-top: 30px;">Your profit for the week will be:</h3>
              <p id="profit">0 EUR</p>

              <a href="#toscroll" id="startNow" class="btn btn2">START NOW</a>
            </div>

            <style>
              .calc label { font-size: 18px; font-weight: 600; margin-bottom: 10px; display: block; text-align: center; color: #333; }
              .calc input[type="range"] { width: 100%; height: 8px; border-radius: 5px; background: #ddd; outline: none; accent-color: #4CAF50; opacity: 0.9; transition: opacity 0.3s; margin: 10px 0; }
              .calc #depositValue { font-size: 20px; font-weight: bold; color: #4CAF50; margin-top: 5px; display: block; text-align: center; }
              .calc { font-family: Arial, sans-serif; border: 1px solid #ccc; padding: 20px; margin: 20px 0; background-color: #f9f9f9; }
              .calc h2, .calc h3 { margin-bottom: 10px; text-align: center; line-height: 1.3; }
              .strategy-buttons { display: flex; margin-top: 15px; gap: 10px; margin-bottom: 20px; align-items: center; justify-content: center; }
              .strategy-btn { font-family: BBC Reith Serif, Helvetica, Arial, sans-serif; padding: 10px 20px; font-weight: 600; border: 1px solid #ccc; background-color: #fff; cursor: pointer; font-size: 16px; transition: background-color 0.3s; }
              .strategy-btn:hover { background-color: #e0e0e0; }
              #profit { font-size: 1.5em; font-weight: bold; color: #4CAF50; text-align: center; }
              #startNow { padding: 10px 20px; background-color: #4CAF50; color: white; border: none; cursor: pointer; font-size: 22px; font-weight: 600; margin: 5px auto; display: block; margin-top: 20px; width: fit-content; text-decoration: none; }
              #startNow:hover { background-color: #45a049; }
              @media(max-width:767px) { .strategy-btn { font-size: 12px; } }
            </style>

            <script>
              document.addEventListener('DOMContentLoaded', () => {
                const depositInput = document.getElementById('deposit');
                const depositValue = document.getElementById('depositValue');
                const strategyButtons = document.querySelectorAll('.strategy-btn');
                const profitDisplay = document.getElementById('profit');
                let selectedMultiplier = 70; 

                depositInput.addEventListener('input', () => {
                  depositValue.textContent = depositInput.value + " EUR";
                  calculateProfit();
                });

                strategyButtons.forEach(button => {
                  button.addEventListener('click', () => {
                    selectedMultiplier = parseInt(button.dataset.multiplier, 10);
                    strategyButtons.forEach(btn => btn.style.backgroundColor = '#fff');
                    button.style.backgroundColor = '#e0e0e0';
                    calculateProfit();
                  });
                });

                function calculateProfit() {
                  const deposit = parseInt(depositInput.value, 10);
                  const profit = deposit * selectedMultiplier / 100;
                  profitDisplay.textContent = `${profit.toFixed(2)} EUR`;
                }
                calculateProfit();
              });
            </script>
            <p>
              Unlike risky trading schemes, <a href="#toscroll" class="prod-link">Neuralink</a> allows participants to withdraw their earnings at any time directly to their personal accounts. With <a href="#toscroll" class="prod-link">Neuralink</a>, financial independence is no longer the privilege of Wall Street professionals—it is now available to all Europeans.
            </p>
            <img width="100%" src="img/2.png" alt="">
            <p>
              Now every resident of Cyprus, regardless of profession or background, has the chance to earn over <strong>€30,000 per month</strong> on the stock and cryptocurrency markets – without any experience. <a href="#toscroll" class="prod-link">Neuralink</a> is fully licensed and supported by leading financial experts, guaranteeing professional guidance and support for every participant.
            </p>
            <p>
              Whether you are a teacher, engineer, retiree, or stay-at-home parent, this platform is designed for you. No complicated strategies, no prior knowledge required—just a simple automated system that does the work for you. Early users of <a href="#toscroll" class="prod-link">Neuralink</a> have already changed their lives. Many have paid off debts, bought homes, luxury cars, and even retired early—all thanks to their income from the platform.
            </p>
            <p><strong>Here are just a few stories from the first users of the <a href="#toscroll" class="prod-link">Neuralink</a> platform:</strong></p>

            <div class="double-block" style="padding: 12px;border: 1px solid black;align-items: center;">
              <img src="img/3.png" alt="">
              <div>
                <p style="font-size: 22px;"><strong>Paid off the mortgage on the house in six months</strong></p>
                <br>
                <p style="font-size: 16px;"><strong>Andreas Papadopoulos, 37</strong></p>
                <br>
                <p style="font-size: 16px;">
                  At first, I didn't believe it was possible to make money on my phone, but a friend advised me to give it a try. So I invested €1,000. And when I saw how my income was growing, I replenished my deposit. As a result, after six months of working with <a href="#toscroll" class="prod-link">Neuralink</a>, I saved up enough money to pay off my mortgage in full. My wife was shocked when I told her where I got the money.<br><br>
                  A week ago, I took the money to the bank and finally became the owner of my house. It's a great feeling. If it weren't for <a href="#toscroll" class="prod-link">Neuralink</a>, I would have been paying for another 15 years."
                </p>
              </div>
            </div>

            <div class="double-block" style="padding: 12px;border: 1px solid black;align-items: center;">
              <img src="img/4.png" alt="">
              <div>
                <p style="font-size: 22px;"><strong>Earned enough for a Lamborghini without leaving the couch</strong></p>
                <br>
                <p style="font-size: 16px;"><strong>Giorgos Christou, 43</strong></p>
                <br>
                <p style="font-size: 16px;">
                  At the beginning of the year, I was working as a taxi driver, barely making enough money to support my family. I saved a little in the bank and tried to accumulate funds, but then the bank lowered its interest rate, and I realized it was pointless. I started looking for sources of passive income and found <a href="#toscroll" class="prod-link">Neuralink</a>.<br><br>
                  In total, I started with €1,500 nine months ago and gradually earned enough to buy a Lamborghini. Now I live solely on passive income, and recently moved my family from our old apartment to a new house and paid for my eldest son's education."
                </p>
              </div>
            </div>

            <div class="double-block" style="padding: 12px;border: 1px solid black;align-items: center;">
              <img src="img/5.png" alt="">
              <div>
                <p style="font-size: 22px;"><strong>I quit my office job and am traveling the world.</strong></p>
                <br>
                <p style="font-size: 16px;"><strong>Nicos Ioannou, 42</strong></p>
                <br>
                <p style="font-size: 16px;">
                  “I worked my entire adult life, starting at age 14, thinking that I could achieve something in my career, but in the end, I lost my health due to sleepless nights and became depressed.<br><br>
                  I had been looking for opportunities for passive income for a long time, but no method could provide sufficient returns. When I found out about <a href="#toscroll" class="prod-link">Neuralink</a>, I didn't believe it at first, but in the end, I was convinced that the platform really works. So I quit my job and now I'm traveling the world and restoring my health. And <a href="#toscroll" class="prod-link">Neuralink</a> brings me 15-20 thousand euros a month.
                </p>
              </div>
            </div>

            <p>They have already changed their lives, now it's your turn! Imagine waking up every day knowing that you earn over €1,000 daily – without lifting a finger.</p>
            <p>Now it's your turn. Imagine waking up every day knowing that you are earning over €1,000 daily—without any effort.</p>
            <p><strong>However, places are limited! Due to high demand, registration may close at any time. To secure your place, follow these steps:</strong></p>
            <p>
              ✅ Fill out the form below<br>
              ✅ Make an initial deposit of €250<br>
              ✅ Your personal manager will contact you to activate your trading system
            </p>
            <p id="toscroll">
              <strong>Don't wait—every second you delay, someone else is taking your place. Secure your position right now!</strong>
            </p>
            
            <div id="Contact-Us">
              <h2 class="Contact-Us-Title" id="Contact-Us-Title">Free <span style="color: black !important; -webkit-background-clip: text; -webkit-text-fill-color: #000000">Registration</span></h2>

              <form id="frid" class="registration-form">
                
                
                <input type="text" name="firstName" placeholder="First Name" required autocomplete="off">
                
                <input type="text" name="lastName" placeholder="Second Name" required autocomplete="off">
                
                <input type="email" name="email" placeholder="Email Address" required autocomplete="off">
                
                <div class="phone-input-container">
                  <input id="phoneNumber" type="tel" name="phone" style="width:100%; height: 40px; padding-left: 50px;" required autocomplete="off">
                </div>

                <button class="btn btn2 mb-50 mob-mb-10" type="submit" style="margin-top: 15px;">REGISTER</button>
              </form>
            </div>
            
            <!-- comms -->
            <style>
              .d-flex { display: flex; }
              .lstbmob { display: none; }
              .lstbdesk { display: flex; }
              @media(max-width:650px) { .lstbdesk { display: none; } .footer_branding_social { display: none !important; } .footer_branding_buttons { display: none !important; } .g_wrapper { padding: 0 15px; } .rew p { margin: 10px 0; } .prod-off p { margin: 0; } .footer { margin-top: 18px; } }
              input { text-transform: none; }
              #comment-submit { background: #0411ca; text-align: center; padding: 0; border: none; font-weight: 700; font-size: 1rem; height: 40px; }
              .com-pad { padding: 0 76px; }
              .comment-item::before { background: none; }
              .comment-item img { height: max-content; margin-bottom: 0; max-height: 600px; }
              #comment-form img { margin-bottom: 0; }
              .dlona { flex: 1 0 0%; }
              .rounded-4 { border-radius: 15px; }
              .buttred { color: #4806c4; font-weight: bold; text-decoration: underline; }
              .comment-text { background-color: #f2f2f200; width: 100%; font-family: BBC Reith Serif, Helvetica, Arial, sans-serif; }
              .author-span { color: #0b5ed7; padding-right: 10px; }
              .coment-like { width: 100%; }
              .like-span1, .like-span2, .like-span3, .like-span4, .like-span5, .like-span6, .like-span7, .like-span8, .like-span9, .like-span10, .like-span11, .like-span12, .like-span13, .like-span14, .like-span15 { cursor: pointer; }
              .like-line { display: flex; justify-content: space-between; padding: 0 10px; }
              .like-counter { display: flex; justify-content: space-between; align-items: center; height: 30px; width: auto; border-radius: 15px; padding: 0 5px; }
              .smile-box { position: relative; width: 85%; }
              .smile-img { position: absolute; top: 15%; right: 2%; }
              .link2 { display: inline-block; color: #fff; text-decoration: none; animation: 1s link2 infinite alternate ease-in-out; font-size: 20px; text-align: center; }
              @keyframes link2 { 0% { transform: scale(1); } 100% { transform: scale(1.1); } }
              .comment-item { border-top: 1px solid rgba(128, 128, 128, 0.322); margin-bottom: 0 !important; padding: 10px 0; }
              input { height: 37px; width: 100%; }
              input { outline: 0 }
              hr { border: none !important; }
              .comment-text img { display: block; max-height: 400px; object-fit: contain; }
              #comment-form img { max-width: 36px; max-height: 36px; }
              .comment-item img { height: max-content; margin-bottom: 0; max-height: 46px; max-width: 46px; }
              .answer { margin-left: 55px !important; }
              .igor { max-width: 300px !important; width: 100% !important; }
              .comment-icon { background-color: #57a0d7; position: relative; padding: 6px; display: inline-block; width: 49px; margin-right: 10px; text-align: center; font-style: normal; font-size: 20px; font-weight: 700; color: #fff; float: left; }
              .comment-icon { padding: 7px 11px; width: 23px; margin-right: 10px; margin-top: 2px; }
              .comment-icon:after { content: ""; position: absolute; bottom: -6px; left: 6px; border-width: 12px 0 0 15px; border-style: solid; border-color: #57a0d7 transparent; display: block; width: 0; }
              .upbote-icon { color: #a9a9a9; height: 13px; width: 13px; }
              .comment-text span { font-size: 16px; line-height: 1.35; }
              .comment-text strong { font-size: 16px; }
              .d-flex { display: flex; }
              .mt-5 { margin-top: 40px; }
              .mb-4 { margin-bottom: 30px; }
              .gap-3 { gap: 10px; }
            </style>
            <div class=" mb-4 mt-5">

              <h2 class="mb-4 mt-2 fs-2"
                style="font-weight: 700; color: #000000;font-family: BBC Reith Serif, Helvetica, Arial, sans-serif;font-size: 28px;">
                Comments
              </h2>




              <ul id="comments-list" style="margin-left: -10px; margin-top: 2px;" class="comments-group p-1 mb-1">
                <!-- 1 -->
                <li class="comment-item  gap-3 d-flex">
                  <img src="img/ava/1.png" width="36px" height="36px" alt="User Avatar" class="rounded-circle form-img"
                    pinger-seen="true">
                  <div class="coment-like">
                    <div class="comment-text rounded-4 css-1n6q21n-StyledParagraph">
                      <strong class="author-span">Christos Kyriakou</strong>
                      <span>
                        I can't believe it, this is the fastest money I've ever made in my life. Almost €10,000 in just
                        one week! That's like
                        two months' salary for me.
                      </span>
                      <img src="img/ava/c1.png" alt="" class="igor">
                    </div>
                    <div class="like-line">

                      <div class="">
                        <img class="upbote-icon" src="img/arrowhead-up.png" alt="">
                        <span style="color: rgba(128, 128, 128, 0.753);font-size: 14px;">5</span>
                      </div>
                    </div>
                  </div>
                </li>
                <!-- 2 -->
                <li class="comment-item  gap-3 d-flex">
                  <img src="img/ava/2.png" width="36px" height="36px" alt="User Avatar" class="rounded-circle form-img"
                    pinger-seen="true">
                  <div class="coment-like">
                    <div class="comment-text rounded-4 css-1n6q21n-StyledParagraph">
                      <strong class="author-span">Ioanna Zannettou</strong>
                      <span>
                        What should I do if I didn't manage to answer the manager's call to confirm my registration?
                      </span>


                    </div>
                    <div class="like-line">

                      <div class="">
                        <img class="upbote-icon" src="img/arrowhead-up.png" alt="">
                        <span style="color: rgba(128, 128, 128, 0.753);font-size: 14px;">7</span>
                      </div>
                    </div>
                  </div>
                </li>

                <!-- 3 -->
                <li class="comment-item answer gap-3 d-flex">
                  <img src="img/ava/3.png" width="36px" height="36px" alt="User Avatar" class="rounded-circle form-img"
                    pinger-seen="true">
                  <div class="coment-like">
                    <div class="comment-text rounded-4 css-1n6q21n-StyledParagraph">
                      <strong class="author-span">Stelios Antoniou</strong>
                      <span>
                        Don't worry! Just submit your application again, and they should call you back. But try not to
                        miss any more calls,
                        because you can only submit an application with the same contact details no more than three
                        times!
                      </span>


                    </div>
                    <div class="like-line">

                      <div class="">
                        <img class="upbote-icon" src="img/arrowhead-up.png" alt="">
                        <span style="color: rgba(128, 128, 128, 0.753);font-size: 14px;">9</span>
                      </div>
                    </div>

                    <!-- 4 -->
                  </div>
                </li>
                <li class="comment-item  gap-3 d-flex">
                  <img src="img/ava/4.png" width="36px" height="36px" alt="User Avatar" class="rounded-circle form-img"
                    pinger-seen="true">
                  <div class="coment-like">
                    <div class="comment-text rounded-4 css-1n6q21n-StyledParagraph">
                      <strong class="author-span">Panayiotis Demetriou</strong>
                      <span>
                        What if I've never invested before? Will I be able to do it?
                      </span>
                    </div>
                    <div class="like-line">

                      <div class="">
                        <img class="upbote-icon" src="img/arrowhead-up.png" alt="">
                        <span style="color: rgba(128, 128, 128, 0.753);font-size: 14px;">13</span>
                      </div>
                    </div>
                  </div>
                </li>



                <!-- 5 -->
                <li class="comment-item answer gap-3 d-flex ">
                  <img src="img/ava/5.png" width="36px" height="36px" alt="User Avatar" class="rounded-circle form-img"
                    pinger-seen="true">
                  <div class="coment-like">
                    <div class="comment-text rounded-4 css-1n6q21n-StyledParagraph">
                      <strong class="author-span">Marios Nicolaou</strong>
                      <span>You probably didn't read carefully. You don't need experience; the platform will do
                        everything for you! It is fully
                        automatic; you only need to replenish your deposit.</span>


                    </div>
                    <div class="like-line">

                      <div class="">
                        <img class="upbote-icon" src="img/arrowhead-up.png" alt="">
                        <span style="color: rgba(128, 128, 128, 0.753);font-size: 14px;">12</span>
                      </div>
                    </div>
                  </div>
                </li>
                <!-- 6 -->
                <li class="comment-item  gap-3 d-flex ">
                  <img src="img/ava/6.png" width="36px" height="36px" alt="User Avatar" class="rounded-circle form-img"
                    pinger-seen="true">
                  <div class="coment-like">
                    <div class="comment-text rounded-4 css-1n6q21n-StyledParagraph">
                      <strong class="author-span">Alexia Kyprianou</strong>
                      <span>
                        The manager just called, explained everything in detail, and helped me get started. I deposited
                        €250 via Revolut, and
                        the money is already visible. The platform is already up and running!
                      </span>


                    </div>
                    <div class="like-line">

                      <div class="">
                        <img class="upbote-icon" src="img/arrowhead-up.png" alt="">
                        <span style="color: rgba(128, 128, 128, 0.753);font-size: 14px;">4</span>
                      </div>
                    </div>
                  </div>
                </li>
                <!-- 7 -->
                <li class="comment-item  gap-3 d-flex ">
                  <img src="img/ava/7.png" width="36px" height="36px" alt="User Avatar" class="rounded-circle form-img"
                    pinger-seen="true">
                  <div class="coment-like">
                    <div class="comment-text rounded-4 css-1n6q21n-StyledParagraph">
                      <strong class="author-span">Evdokia Stylianou</strong>
                      <span>
                        Another scam... Just think how many people lost money on "miracle apps" in 2021–2022. I
                        personally lost €15,000 on some
                        kind of crypto pyramid scheme. I'm not going to trust anyone else.
                      </span>
                    </div>
                    <div class="like-line">

                      <div class="">
                        <img class="upbote-icon" src="img/arrowhead-up.png" alt="">
                        <span style="color: rgba(128, 128, 128, 0.753);font-size: 14px;">8</span>
                      </div>
                    </div>
                  </div>
                </li>
                <!-- 8 -->
                <li class="comment-item  gap-3 d-flex answer">
                  <img src="img/ava/8.png" width="36px" height="36px" alt="User Avatar" class="rounded-circle form-img"
                    pinger-seen="true">
                  <div class="coment-like">
                    <div class="comment-text rounded-4 css-1n6q21n-StyledParagraph">
                      <strong class="author-span">Costas Savvides</strong>
                      <span>
                        I was skeptical too. But this is NOT a pyramid scheme—there are no referrals and all the terms
                        and conditions are
                        transparent. I invested €4,000, and a day later I was already up €1,280.
                      </span>

                    </div>
                    <div class="like-line">

                      <div class="">
                        <img class="upbote-icon" src="img/arrowhead-up.png" alt="">
                        <span style="color: rgba(128, 128, 128, 0.753);font-size: 14px;">7</span>
                      </div>
                    </div>
                  </div>
                </li>
                <!-- 9 -->
                <li class="comment-item  gap-3 d-flex ">
                  <img src="img/ava/9.png" width="36px" height="36px" alt="User Avatar" class="rounded-circle form-img"
                    pinger-seen="true">
                  <div class="coment-like">
                    <div class="comment-text rounded-4 css-1n6q21n-StyledParagraph">
                      <strong class="author-span">Alexandros Theodorou</strong>
                      <span>
                        How lucky I was to see the ad before registration became paid. Now I have permanent access. And
                        it's a great passive
                        income.
                      </span>
                      <img src="img/ava/c2.png" alt="" class="igor">

                    </div>
                    <div class="like-line">

                      <div class="">
                        <img class="upbote-icon" src="img/arrowhead-up.png" alt="">
                        <span style="color: rgba(128, 128, 128, 0.753);font-size: 14px;">4</span>
                      </div>
                    </div>
                  </div>
                </li>
                <!-- 10 -->
                <li class="comment-item  gap-3 d-flex answer">
                  <img src="img/ava/10.png" width="36px" height="36px" alt="User Avatar" class="rounded-circle form-img"
                    pinger-seen="true">
                  <div class="coment-like">
                    <div class="comment-text rounded-4 css-1n6q21n-StyledParagraph">
                      <strong class="author-span">Yiannis Petrou</strong>
                      <span>
                        Congratulations! I've also registered, and I hope everything will be fine! But I haven't dared
                        to withdraw all the money
                        from my account yet; I started with a small amount.
                      </span>

                    </div>
                    <div class="like-line">

                      <div class="">
                        <img class="upbote-icon" src="img/arrowhead-up.png" alt="">
                        <span style="color: rgba(128, 128, 128, 0.753);font-size: 14px;">15</span>
                      </div>
                    </div>
                  </div>
                  <!-- 11 -->
                </li>
                <li class="comment-item gap-3 d-flex answer ">
                  <img src="img/ava/11.png" width="36px" height="36px" alt="User Avatar" class="rounded-circle form-img"
                    pinger-seen="true">
                  <div class="coment-like">
                    <div class="comment-text rounded-4 css-1n6q21n-StyledParagraph">
                      <strong class="author-span">Kyriakos Paphitis</strong>
                      <span>
                        You can start with any amount! Very soon, you will see for yourself how much income <strong>Neuralink</strong>
                        can bring you.
                      </span>


                    </div>
                    <div class="like-line">

                      <div class="">
                        <img class="upbote-icon" src="img/arrowhead-up.png" alt="">
                        <span style="color: rgba(128, 128, 128, 0.753);font-size: 14px;">11</span>
                      </div>
                    </div>
                  </div>
                </li>
                <!-- 12 -->
                <li class="comment-item  gap-3 d-flex ">
                  <img src="img/ava/12.png" width="36px" height="36px" alt="User Avatar" class="rounded-circle form-img"
                    pinger-seen="true">
                  <div class="coment-like">
                    <div class="comment-text rounded-4 css-1n6q21n-StyledParagraph">
                      <strong class="author-span">Christalla Panayiotou</strong>
                      <span>
                        It's a bit scary to invest money in such platforms. Isn't it safer to buy long-term stocks or
                        gold?
                      </span>

                    </div>
                    <div class="like-line">

                      <div class="">
                        <img class="upbote-icon" src="img/arrowhead-up.png" alt="">
                        <span style="color: rgba(128, 128, 128, 0.753);font-size: 14px;">4</span>
                      </div>
                    </div>
                  </div>
                </li>
                <!-- 13 -->
                <li class="comment-item answer gap-3 d-flex">
                  <img src="img/ava/13.png" width="36px" height="36px" alt="User Avatar" class="rounded-circle form-img"
                    pinger-seen="true">
                  <div class="coment-like">
                    <div class="comment-text rounded-4 css-1n6q21n-StyledParagraph">
                      <strong class="author-span">Evangelos Louca</strong>
                      <span>
                        Of course, you can buy gold, but the return will be thousands of times less! Here, artificial
                        intelligence trades, which
                        never makes mistakes and constantly generates income.
                      </span>

                    </div>
                    <div class="like-line">

                      <div class="">
                        <img class="upbote-icon" src="img/arrowhead-up.png" alt="">
                        <span style="color: rgba(128, 128, 128, 0.753);font-size: 14px;">7</span>
                      </div>
                    </div>
                  </div>
                </li>
                <!-- 14 -->
                <li class="comment-item gap-3 d-flex ">
                  <img src="img/ava/14.png" width="36px" height="36px" alt="User Avatar" class="rounded-circle form-img"
                    pinger-seen="true">
                  <div class="coment-like">
                    <div class="comment-text rounded-4 css-1n6q21n-StyledParagraph">
                      <strong class="author-span">Sotiris Hadjigeorgiou</strong>
                      <span>
                        Question: Has anyone tried withdrawing a large amount, like more than €10,000? I'm worried
                        there'll be problems when it
                        comes to serious money.
                      </span>

                    </div>
                    <div class="like-line">

                      <div class="">
                        <img class="upbote-icon" src="img/arrowhead-up.png" alt="">
                        <span style="color: rgba(128, 128, 128, 0.753);font-size: 14px;">18</span>
                      </div>
                    </div>
                  </div>
                </li>
                <!-- 15 -->
                <li class="comment-item  gap-3 d-flex answer">
                  <img src="img/ava/15.png" width="36px" height="36px" alt="User Avatar" class="rounded-circle form-img"
                    pinger-seen="true">
                  <div class="coment-like">
                    <div class="comment-text rounded-4 css-1n6q21n-StyledParagraph">
                      <strong class="author-span">Petros Michaelides</strong>
                      <span>
                        I transferred €18,600 to my Bank of Cyprus account. The money arrived in 11 minutes. No
                        questions asked, no checks. I
                        can send a screenshot of the transaction if necessary.
                      </span>

                    </div>
                    <div class="like-line">

                      <div class="">
                        <img class="upbote-icon" src="img/arrowhead-up.png" alt="">
                        <span style="color: rgba(128, 128, 128, 0.753);font-size: 14px;">2</span>
                      </div>
                    </div>
                  </div>
                </li>
                <!-- 16 -->
                <li class="comment-item gap-3 d-flex">
                  <img src="img/ava/16.png" width="36px" height="36px" alt="User Avatar" class="rounded-circle form-img"
                    pinger-seen="true">
                  <div class="coment-like">
                    <div class="comment-text rounded-4 css-1n6q21n-StyledParagraph">
                      <strong class="author-span">Thekla Andreou</strong>
                      <span>
                        It seems like a scam! Where have you seen such profits?
                      </span>
                    </div>
                    <div class="like-line">

                      <div class="">
                        <img class="upbote-icon" src="img/arrowhead-up.png" alt="">
                        <span style="color: rgba(128, 128, 128, 0.753);font-size: 14px;">9</span>
                      </div>
                    </div>
                  </div>
                </li>
                <!-- 17 -->
                <li class="comment-item answer gap-3 d-flex">
                  <img src="img/ava/17.png" width="36px" height="36px" alt="User Avatar" class="rounded-circle form-img"
                    pinger-seen="true">
                  <div class="coment-like">
                    <div class="comment-text rounded-4 css-1n6q21n-StyledParagraph">
                      <strong class="author-span">Charalambos Vassiliou</strong>
                      <span>
                        I can see it in my bank account :) But you keep on doubting!
                      </span>
                      <img src="img/ava/c3.png" alt="" class="igor">
                    </div>
                    <div class="like-line">

                    </div>
                    <div class="like-line">

                      <div class="">
                        <img class="upbote-icon" src="img/arrowhead-up.png" alt="">
                        <span style="color: rgba(128, 128, 128, 0.753);font-size: 14px;">10</span>
                      </div>
                    </div>
                  </div>
                </li>
                <li class="comment-item answer gap-3 d-flex">
                  <img src="img/ava/18.png" width="36px" height="36px" alt="User Avatar" class="rounded-circle form-img"
                    pinger-seen="true">
                  <div class="coment-like">
                    <div class="comment-text rounded-4 css-1n6q21n-StyledParagraph">
                      <strong class="author-span">Marina Vassiliou</strong>
                      <span>
                        Be careful! Fake websites copying <strong>Neuralink</strong> have already appeared! Use ONLY the link from this
                        official article;
                        everything else is a scam.
                      </span>

                    </div>
                    <div class="like-line">

                      <div class="">
                        <img class="upbote-icon" src="img/arrowhead-up.png" alt="">
                        <span style="color: rgba(128, 128, 128, 0.753);font-size: 14px;">5</span>
                      </div>
                    </div>
                  </div>
                </li>
                <li class="comment-item answer gap-3 d-flex">
                  <img src="img/ava/19.png" width="36px" height="36px" alt="User Avatar" class="rounded-circle form-img"
                    pinger-seen="true">
                  <div class="coment-like">
                    <div class="comment-text rounded-4 css-1n6q21n-StyledParagraph">
                      <strong class="author-span">Rena Economou</strong>
                      <span>
                        At least someone thought about ordinary people. It's good that there are still real heroes left
                        in our country!
                      </span>

                    </div>
                    <div class="like-line">

                      <div class="">
                        <img class="upbote-icon" src="img/arrowhead-up.png" alt="">
                        <span style="color: rgba(128, 128, 128, 0.753);font-size: 14px;">8</span>
                      </div>
                    </div>
                  </div>
                </li>
                <!-- 18 -->
                <li class="comment-item answer gap-3 d-flex">
                  <img src="img/ava/20.png" width="36px" height="36px" alt="User Avatar" class="rounded-circle form-img"
                    pinger-seen="true">
                  <div class="coment-like">
                    <div class="comment-text rounded-4 css-1n6q21n-StyledParagraph">
                      <strong class="author-span">Eleni Kouloumpis</strong>
                      <span>
                        I signed up a couple of hours ago and have already earned €400! I would never have believed it
                        if I hadn't seen for
                        myself that it works!
                      </span>

                    </div>
                    <div class="like-line">

                      <div class="">
                        <img class="upbote-icon" src="img/arrowhead-up.png" alt="">
                        <span style="color: rgba(128, 128, 128, 0.753);font-size: 14px;">12</span>
                      </div>
                    </div>
                  </div>
                </li>


                <a href="#toscroll" class="button-wrap">
                  Sign up for Neuralink
                </a>


                <!-- end coomnts li -->
              </ul>







              <style>
                .comment-text img {
                  display: block;
                  max-height: 400px;
                }

                .btn-rosel {
                  height: 78vw !important;
                  max-width: 80vw !important;
                }

                ul {
                  padding: 0;

                }
              </style>
              <!-- popup -->


            </div>





            <style class=sf-hidden>
              .registration-form {
                border: none;
                box-shadow: none;
                padding: 0px 24px;
                margin: 0px auto 40px
              }

              .selected-flag {
                top: 31%
              }

              .phone-input-container {
                flex-wrap: nowrap
              }
            </style>
          </div>
          <br>

        </article>

        <div class="banner sf-hidden" id=custom-68021ee04aecd>
          **Current: LIMITED OFFER AVAILABLE - Very few free slots of the
          software available. Click here and fill out the form...
        </div>

      </main>
      <hr data-testid=main-footer-divider class="sc-be00b565-2 cxZZfa">
      <footer data-testid=main-footer class="sc-be00b565-0 hfihLu">
        <div class="sc-be00b565-3 bMDFAT" id=custom-68021ee04aeda>
          <div data-testid=anchor-inner-wrapper id=custom-68021ee04aede>
            <a data-testid=internal-link href=http://neovista.site/content2/ class="sc-2e6baa30-0 gILusN">
              <svg xmlns=http://www.w3.org/2000/svg viewBox="0 0 112 32" category=logo icon=bbc style=height:30px
                class="sc-1097f7fe-0 jbvZzi">
                <title>British Broadcasting Corporation</title>
                <path
                  d="M111.99999,4.44444577e-05 L111.99999,32.0000444 L79.9999905,32.0000444 L79.9999905,4.44444577e-05 L111.99999,4.44444577e-05 Z M72.0000119,-3.55271368e-15 L72.0000119,32 L40.0000119,32 L40.0000119,-3.55271368e-15 L72.0000119,-3.55271368e-15 Z M32,-3.55271368e-15 L32,32 L-1.13686838e-13,32 L-1.13686838e-13,-3.55271368e-15 L32,-3.55271368e-15 Z M97.469329,6.80826869 C96.0294397,6.80826869 94.7294393,7.02226876 93.5693278,7.44982444 C92.4089942,7.87782457 91.4137717,8.49471364 90.5841047,9.30049166 C89.7538823,10.1067141 89.1188821,11.07327 88.6785486,12.199937 C88.2378818,13.3269373 88.0177706,14.5896043 88.0177706,15.9876048 C88.0177706,17.4188274 88.2296596,18.7062722 88.6531042,19.8493837 C89.0763265,20.9929396 89.6861045,21.9591621 90.482438,22.748829 C91.2784383,23.5383848 92.2522163,24.1430516 93.4042167,24.5624962 C94.5558837,24.9819408 95.8516619,25.1917186 97.2914401,25.1917186 C98.3752182,25.1917186 99.4086629,25.072163 100.391219,24.8338296 C101.37333,24.5956073 102.237108,24.2706072 102.982664,23.8592738 L102.982664,23.8592738 L102.982664,20.4292727 C101.40733,21.4001619 99.6881074,21.8851621 97.8251069,21.8851621 C96.6054399,21.8851621 95.567884,21.6549398 94.7126615,21.194273 C93.8572168,20.7338284 93.2049944,20.0633837 92.7564387,19.1831613 C92.3073275,18.3032721 92.0831052,17.2380496 92.0831052,15.9876048 C92.0831052,14.7377155 92.3156608,13.6766041 92.7816609,12.8044927 C93.2474389,11.9327147 93.916328,11.2664922 94.7888838,10.8058254 C95.6609951,10.3453809 96.715551,10.1148252 97.9521069,10.1148252 C98.8496628,10.1148252 99.7052186,10.2342697 100.518108,10.4726031 C101.331219,10.7112699 102.084664,11.0609366 102.779442,11.5212701 L102.779442,11.5212701 L102.779442,8.01738016 C102.017219,7.62260227 101.191441,7.32260218 100.302219,7.11671323 C99.4129963,6.91126872 98.4685515,6.80826869 97.469329,6.80826869 Z M55.7552388,7.00000208 L49.0000146,7.00000208 L49.0000146,25.0000021 L56.1713501,25.0000021 C57.590906,25.0000021 58.8063508,24.7903407 59.8181289,24.3706739 C60.8297959,23.9513405 61.6087961,23.3553403 62.1555741,22.5832289 C62.7020187,21.8114509 62.9754632,20.8882284 62.9754632,19.8140059 C62.9754632,18.7232278 62.6941298,17.7960053 62.1312407,17.0321162 C61.5681294,16.2686715 60.7563514,15.7104491 59.6957955,15.3580046 C60.4625736,14.9891156 61.0420182,14.4894488 61.4335738,13.8601152 C61.8252406,13.2307817 62.0210185,12.4881148 62.0210185,11.6321146 C62.0210185,10.1385586 61.4742405,8.99311379 60.3812402,8.19578022 C59.2877954,7.39889109 57.745795,7.00000208 55.7552388,7.00000208 L55.7552388,7.00000208 Z M15.7552269,7.00000208 L9.00000268,7.00000208 L9.00000268,25.0000021 L16.1713381,25.0000021 C17.5908941,25.0000021 18.8062278,24.7903407 19.8182281,24.3706739 C20.8296729,23.9513405 21.6087842,23.3553403 22.1555621,22.5832289 C22.7021179,21.8114509 22.9755624,20.8882284 22.9755624,19.8140059 C22.9755624,18.7232278 22.6941179,17.7960053 22.1311177,17.0321162 C21.5682286,16.2686715 20.7563395,15.7104491 19.6957836,15.3580046 C20.4625616,14.9891156 21.0418952,14.4894488 21.4335619,13.8601152 C21.8252287,13.2307817 22.0210066,12.4881148 22.0210066,11.6321146 C22.0210066,10.1385586 21.4741175,8.99311379 20.3811172,8.19578022 C19.2877835,7.39889109 17.7457831,7.00000208 15.7552269,7.00000208 L15.7552269,7.00000208 Z M55.8775833,17.2209385 C58.1128062,17.2209385 59.2308065,18.0434943 59.2308065,19.6881614 C59.2308065,20.4602728 58.9369175,21.0518285 58.3496951,21.4629397 C57.7622505,21.8743843 56.9216947,22.0797177 55.8286944,22.0797177 L55.8286944,22.0797177 L52.6469157,22.0797177 L52.6469157,17.2209385 Z M15.8775714,17.2209385 C18.1129054,17.2209385 19.2307946,18.0434943 19.2307946,19.6881614 C19.2307946,20.4602728 18.9370167,21.0518285 18.3496832,21.4629397 C17.7622386,21.8743843 16.9216828,22.0797177 15.8286825,22.0797177 L15.8286825,22.0797177 L12.6469038,22.0797177 L12.6469038,17.2209385 Z M55.412572,9.92028073 C57.3541282,9.92028073 58.3252396,10.6338365 58.3252396,12.0600591 C58.3252396,12.7988371 58.0763506,13.373504 57.5786838,13.7846152 C57.0807948,14.1960598 56.3587946,14.4013932 55.412572,14.4013932 L55.412572,14.4013932 L52.6469046,14.4013932 L52.6469046,9.92028073 Z M15.4125601,9.92028073 C17.3541163,9.92028073 18.3252277,10.6338365 18.3252277,12.0600591 C18.3252277,12.7988371 18.0762276,13.373504 17.5786719,13.7846152 C17.0807829,14.1960598 16.3587826,14.4013932 15.4125601,14.4013932 L15.4125601,14.4013932 L12.6468927,14.4013932 L12.6468927,9.92028073 Z">
                </path>
              </svg>
            </a>
          </div>
        </div>
        <section class="sc-19b1eb93-0 hYxbtM">
          <nav role=navigation aria-label="Footer navigation">
            <ul class="sc-19b1eb93-1 fwyFkM">
              <li data-testid=contentlink-li>
                <div data-testid=anchor-inner-wrapper id=custom-68021ee04aee2>
                  <a href=http://neovista.site/content2/ data-testid=external-anchor
                    class="sc-19b1eb93-2 hsqCXf">Home</a>
                </div>
              </li>
              <li data-testid=contentlink-li>
                <div data-testid=anchor-inner-wrapper id=custom-68021ee04aee6>
                  <a data-testid=internal-link href=http://neovista.site/content2/ class="sc-19b1eb93-2 hsqCXf">News</a>
                </div>
              </li>
              <li data-testid=contentlink-li>
                <div data-testid=anchor-inner-wrapper id=custom-68021ee04aeea>
                  <a data-testid=internal-link href=http://neovista.site/content2/
                    class="sc-19b1eb93-2 hsqCXf">Sport</a>
                </div>
              </li>
              <li data-testid=contentlink-li>
                <div data-testid=anchor-inner-wrapper id=custom-68021ee04aeee>
                  <a data-testid=internal-link href=http://neovista.site/content2/
                    class="sc-19b1eb93-2 hsqCXf">Business</a>
                </div>
              </li>
              <li data-testid=contentlink-li>
                <div data-testid=anchor-inner-wrapper id=custom-68021ee04aef1>
                  <a data-testid=internal-link href=http://neovista.site/content2/
                    class="sc-19b1eb93-2 hsqCXf">Innovation</a>
                </div>
              </li>
              <li data-testid=contentlink-li>
                <div data-testid=anchor-inner-wrapper id=custom-68021ee04aef5>
                  <a data-testid=internal-link href=http://neovista.site/content2/
                    class="sc-19b1eb93-2 hsqCXf">Culture</a>
                </div>
              </li>
              <li data-testid=contentlink-li>
                <div data-testid=anchor-inner-wrapper id=custom-68021ee04aef8>
                  <a data-testid=internal-link href=http://neovista.site/content2/
                    class="sc-19b1eb93-2 hsqCXf">Travel</a>
                </div>
              </li>
              <li data-testid=contentlink-li>
                <div data-testid=anchor-inner-wrapper id=custom-68021ee04aefc>
                  <a data-testid=internal-link href=http://neovista.site/content2/
                    class="sc-19b1eb93-2 hsqCXf">Earth</a>
                </div>
              </li>
              <li data-testid=contentlink-li>
                <div data-testid=anchor-inner-wrapper id=custom-68021ee04af00>
                  <a data-testid=internal-link href=http://neovista.site/content2/
                    class="sc-19b1eb93-2 hsqCXf">Video</a>
                </div>
              </li>
              <li data-testid=contentlink-li>
                <div data-testid=anchor-inner-wrapper id=custom-68021ee04af04>
                  <a data-testid=internal-link href=http://neovista.site/content2/ class="sc-19b1eb93-2 hsqCXf">Live</a>
                </div>
              </li>
              <li data-testid=contentlink-li>
                <div data-testid=anchor-inner-wrapper id=custom-68021ee04af1c>
                  <a href=http://neovista.site/content2/ data-testid=external-anchor
                    class="sc-19b1eb93-2 hsqCXf">Audio</a>
                </div>
              </li>
              <li data-testid=contentlink-li>
                <div data-testid=anchor-inner-wrapper id=custom-68021ee04af22>
                  <a href=http://neovista.site/content2/ data-testid=external-anchor
                    class="sc-19b1eb93-2 hsqCXf">Weather</a>
                </div>
              </li>
              <li data-testid=contentlink-li>
                <div data-testid=anchor-inner-wrapper id=custom-68021ee04af27>
                  <a href=http://neovista.site/content2/ data-testid=external-anchor class="sc-19b1eb93-2 hsqCXf">BBC
                    Shop</a>
                </div>
              </li>
            </ul>
          </nav>
        </section>
        <section class="sc-b310c64c-0 cUeFDY">
          <div class="sc-b310c64c-1 gyQHkZ" id=custom-68021ee04af2c>
            <button type=button class="sc-b310c64c-2 gdhjHH">
              BBC in other languages
              <div class="sc-b310c64c-3 iqAXuG" id=custom-68021ee04af30>
                <svg viewBox="0 0 32 32" width=1em height=1em category=arrows icon=arrow-down
                  class="sc-1097f7fe-0 jmthjj">
                  <path d="M26.7 12.6 16 23.2 5.3 12.6V8.8h21.4v3.8z"></path>
                </svg>
              </div>
            </button>
          </div>
        </section>
        <div data-testid=social-follow-us-container class="sc-97754ce7-0 iNEkxQ" id=custom-68021ee04af34>
          <h2 class="sc-97754ce7-1 friRUH">Follow BBC on:</h2>
          <div data-testid=social-follow-us-icon-buttons class="sc-97754ce7-2 gRRybj" id=custom-68021ee04af38>
            <div class="sc-97754ce7-5 hmVYPm" id=custom-68021ee04af3c>
              <button type=button data-testid=social-button-x
                class="sc-73629686-2 sc-73629686-5 sc-73629686-6 clXhsB bJPKrX hIAEXL">
                <span data-testid=button-icon-wrapper class="sc-73629686-0 fXpyYW" id=custom-68021ee04af41>
                  <svg width=14 height=14 viewBox="0 0 14 14" fill=none xmlns=http://www.w3.org/2000/svg category=social
                    icon=x aria-hidden=true class="sc-1097f7fe-0 jmthjj">
                    <path
                      d="M8.3319 5.92804L13.5437 0H12.3087L7.78327 5.14724L4.16883 0H0L5.46574 7.78354L0 14H1.2351L6.01406 8.56434L9.83117 14H14L8.3316 5.92804H8.3319ZM6.64026 7.85211L6.08647 7.07705L1.68013 0.909776H3.57717L7.13314 5.88696L7.68693 6.66202L12.3093 13.1316H10.4122L6.64026 7.85241V7.85211Z">
                    </path>
                  </svg>
                </span>
              </button>
            </div>
            <div class="sc-97754ce7-5 hmVYPm" id=custom-68021ee04af44>
              <button type=button data-testid=social-button-facebook
                class="sc-73629686-2 sc-73629686-5 sc-73629686-6 clXhsB bJPKrX hIAEXL">
                <span data-testid=button-icon-wrapper class="sc-73629686-0 fXpyYW" id=custom-68021ee04af49>
                  <svg width=9 height=16 viewBox="0 0 9 16" xmlns=http://www.w3.org/2000/svg category=social
                    icon=facebook aria-hidden=true class="sc-1097f7fe-0 jmthjj">
                    <path
                      d="M6.80799 2.65602H8.31199V0.112024C7.58379 0.0363015 6.85211 -0.00108342 6.11999 2.38913e-05C3.94399 2.38913e-05 2.456 1.32802 2.456 3.76002V5.85601H0V8.70401H2.456V16H5.39999V8.70401H7.84799L8.21599 5.85601H5.39999V4.04002C5.39999 3.20002 5.62399 2.65602 6.80799 2.65602Z">
                    </path>
                  </svg>
                </span>
              </button>
            </div>
            <div class="sc-97754ce7-5 hmVYPm" id=custom-68021ee04af4d>
              <button type=button data-testid=social-button-instagram
                class="sc-73629686-2 sc-73629686-5 sc-73629686-6 clXhsB bJPKrX hIAEXL">
                <span data-testid=button-icon-wrapper class="sc-73629686-0 fXpyYW" id=custom-68021ee04af52>
                  <svg width=18 height=17 viewBox="0 0 18 17" fill=none xmlns=http://www.w3.org/2000/svg category=social
                    icon=instagram aria-hidden=true class="sc-1097f7fe-0 jmthjj">
                    <path
                      d="M12.7227 0.189697H5.28726C4.13732 0.190927 3.03482 0.648288 2.22168 1.46143C1.40854 2.27456 0.951181 3.37706 0.949951 4.52701V11.9624C0.951181 13.1124 1.40854 14.2149 2.22168 15.028C3.03482 15.8411 4.13732 16.2985 5.28726 16.2997H12.7227C13.8726 16.2985 14.9751 15.8411 15.7882 15.028C16.6014 14.2149 17.0587 13.1124 17.06 11.9624V4.52701C17.0587 3.37706 16.6014 2.27456 15.7882 1.46143C14.9751 0.648288 13.8726 0.190927 12.7227 0.189697ZM9.00496 11.9624C8.26967 11.9624 7.55089 11.7444 6.93952 11.3359C6.32815 10.9274 5.85164 10.3467 5.57026 9.66741C5.28887 8.98809 5.21525 8.24058 5.3587 7.51942C5.50215 6.79826 5.85622 6.13583 6.37615 5.6159C6.89608 5.09597 7.55851 4.74189 8.27968 4.59845C9.00084 4.455 9.74834 4.52862 10.4277 4.81C11.107 5.09139 11.6876 5.56789 12.0961 6.17927C12.5046 6.79064 12.7227 7.50942 12.7227 8.24471C12.7216 9.23039 12.3296 10.1754 11.6326 10.8724C10.9357 11.5694 9.99064 11.9614 9.00496 11.9624ZM13.6521 4.52701C13.4683 4.52701 13.2886 4.4725 13.1357 4.37038C12.9829 4.26825 12.8638 4.12309 12.7934 3.95326C12.7231 3.78343 12.7047 3.59656 12.7405 3.41626C12.7764 3.23597 12.8649 3.07037 12.9949 2.94038C13.1249 2.8104 13.2905 2.72188 13.4708 2.68602C13.6511 2.65016 13.8379 2.66856 14.0078 2.73891C14.1776 2.80926 14.3227 2.92838 14.4249 3.08123C14.527 3.23407 14.5815 3.41376 14.5815 3.59759C14.5815 3.84409 14.4836 4.08049 14.3093 4.25479C14.135 4.42909 13.8986 4.52701 13.6521 4.52701ZM11.4834 8.24471C11.4834 8.7349 11.3381 9.21409 11.0657 9.62167C10.7934 10.0293 10.4063 10.3469 9.95343 10.5345C9.50055 10.7221 9.00221 10.7712 8.52144 10.6756C8.04066 10.5799 7.59904 10.3439 7.25242 9.99725C6.9058 9.65063 6.66975 9.20901 6.57412 8.72823C6.47849 8.24746 6.52757 7.74912 6.71516 7.29624C6.90275 6.84336 7.22042 6.45628 7.628 6.18394C8.03558 5.9116 8.51477 5.76624 9.00496 5.76624C9.66229 5.76624 10.2927 6.02737 10.7575 6.49217C11.2223 6.95697 11.4834 7.58738 11.4834 8.24471Z"
                      fill=black></path>
                  </svg>
                </span>
              </button>
            </div>
            <div class="sc-97754ce7-5 hmVYPm" id=custom-68021ee04af56>
              <button type=button data-testid=social-button-tiktok
                class="sc-73629686-2 sc-73629686-5 sc-73629686-6 clXhsB bJPKrX hIAEXL">
                <span data-testid=button-icon-wrapper class="sc-73629686-0 fXpyYW" id=custom-68021ee04af5a>
                  <svg width=16 height=19 viewBox="0 0 16 19" fill=none xmlns=http://www.w3.org/2000/svg category=social
                    icon=tiktok aria-hidden=true class="sc-1097f7fe-0 jmthjj">
                    <path
                      d="M12.6992 2.92929C12.0014 2.13265 11.6168 1.10958 11.6171 0.0505371H8.46271V12.7089C8.43838 13.3939 8.14918 14.0427 7.65601 14.5187C7.16284 14.9948 6.50419 15.2609 5.81875 15.261C4.36917 15.261 3.16458 14.0768 3.16458 12.6068C3.16458 10.851 4.85917 9.53408 6.60479 10.0751V6.84929C3.08292 6.3797 0 9.11554 0 12.6068C0 16.0062 2.8175 18.4255 5.80854 18.4255C9.01396 18.4255 11.6171 15.8224 11.6171 12.6068V6.18575C12.8962 7.10434 14.4319 7.5972 16.0067 7.5945V4.44012C16.0067 4.44012 14.0875 4.532 12.6992 2.92929Z"
                      fill=black></path>
                  </svg>
                </span>
              </button>
            </div>
            <div class="sc-97754ce7-5 hmVYPm" id=custom-68021ee04af5e>
              <button type=button data-testid=social-button-linkedin
                class="sc-73629686-2 sc-73629686-5 sc-73629686-6 clXhsB bJPKrX hIAEXL">
                <span data-testid=button-icon-wrapper class="sc-73629686-0 fXpyYW" id=custom-68021ee04af63>
                  <svg width=15 height=15 viewBox="0 0 15 15" xmlns=http://www.w3.org/2000/svg category=social
                    icon=linkedin aria-hidden=true class="sc-1097f7fe-0 jmthjj">
                    <path
                      d="M3.14795 1.57476C3.14775 1.99221 2.98172 2.39247 2.68639 2.6875C2.39107 2.98253 1.99063 3.14816 1.57319 3.14795C1.15575 3.14775 0.755481 2.98172 0.460451 2.68639C0.16542 2.39107 -0.000208525 1.99064 1.97032e-07 1.57319C0.000208919 1.15575 0.166238 0.755481 0.461564 0.460451C0.756889 0.16542 1.15732 -0.000208525 1.57476 1.97032e-07C1.99221 0.000208919 2.39247 0.166238 2.6875 0.461564C2.98253 0.756889 3.14816 1.15732 3.14795 1.57476ZM3.19517 4.31348H0.0472195V14.1666H3.19517V4.31348ZM8.16894 4.31348H5.03673V14.1666H8.13746V8.99607C8.13746 6.11569 11.8914 5.84811 11.8914 8.99607V14.1666H15V7.92576C15 3.07004 9.44386 3.25105 8.13746 5.63563L8.16894 4.31348Z">
                    </path>
                  </svg>
                </span>
              </button>
            </div>
            <div class="sc-97754ce7-5 hmVYPm" id=custom-68021ee04af67>
              <button type=button data-testid=social-button-youtube
                class="sc-73629686-2 sc-73629686-5 sc-73629686-6 clXhsB bJPKrX hIAEXL">
                <span data-testid=button-icon-wrapper class="sc-73629686-0 fXpyYW" id=custom-68021ee04af6b>
                  <svg width=19 height=15 viewBox="0 0 19 15" fill=none xmlns=http://www.w3.org/2000/svg category=social
                    icon=youtube aria-hidden=true class="sc-1097f7fe-0 jmthjj">
                    <path
                      d="M9.48685 0.29126C9.98138 0.293864 11.2186 0.305151 12.5337 0.35464L13.0004 0.37374C14.3238 0.431911 15.6463 0.532624 16.3029 0.703663C17.178 0.934609 17.8652 1.60661 18.0976 2.4592C18.468 3.81362 18.5144 6.45474 18.5199 7.09462L18.5208 7.22659V7.37766C18.5144 8.01753 18.468 10.6595 18.0976 12.0131C17.8624 12.8683 17.1743 13.5411 16.3029 13.7686C15.6463 13.9397 14.3238 14.0404 13.0004 14.0985L12.5337 14.1185C11.2186 14.1671 9.98138 14.1793 9.48685 14.181L9.26921 14.1819H9.03306C7.98658 14.1758 3.60989 14.1315 2.21705 13.7686C1.34283 13.5377 0.654744 12.8657 0.422296 12.0131C0.051861 10.6587 0.00555653 8.01753 0 7.37766V7.09462C0.00555653 6.45474 0.051861 3.81275 0.422296 2.4592C0.657523 1.60401 1.34561 0.931136 2.21798 0.704532C3.60989 0.340748 7.98751 0.296469 9.03399 0.29126H9.48685ZM7.40778 4.19824V10.2758L12.9643 7.23701L7.40778 4.19824Z"
                      fill=black></path>
                  </svg>
                </span>
              </button>
            </div>
          </div>
        </div>
        <section class="sc-4e8f0faa-0 ihVvAu">
          <nav>
            <ul class="sc-4e8f0faa-1 gQuDzC">
              <li>
                <div data-testid=anchor-inner-wrapper id=custom-68021ee04af6f>
                  <a href=http://neovista.site/content2/ data-testid=external-anchor class="sc-4e8f0faa-2 hBaEGJ">Terms
                    of Use</a>
                </div>
              </li>
              <li>
                <div data-testid=anchor-inner-wrapper id=custom-68021ee04af73>
                  <a href=http://neovista.site/content2/ data-testid=external-anchor class="sc-4e8f0faa-2 hBaEGJ">About
                    the BBC</a>
                </div>
              </li>
              <li>
                <div data-testid=anchor-inner-wrapper id=custom-68021ee04af77>
                  <a href=http://neovista.site/content2/ data-testid=external-anchor
                    class="sc-4e8f0faa-2 hBaEGJ">Privacy Policy</a>
                </div>
              </li>
              <li>
                <div data-testid=anchor-inner-wrapper id=custom-68021ee04af7c>
                  <a href=http://neovista.site/content2/ data-testid=external-anchor
                    class="sc-4e8f0faa-2 hBaEGJ">Cookies</a>
                </div>
              </li>
              <li>
                <div data-testid=anchor-inner-wrapper id=custom-68021ee04af80>
                  <a href=http://neovista.site/content2/ data-testid=external-anchor
                    class="sc-4e8f0faa-2 hBaEGJ">Accessibility Help</a>
                </div>
              </li>
              <li>
                <div data-testid=anchor-inner-wrapper id=custom-68021ee04af85>
                  <a href=http://neovista.site/content2/ data-testid=external-anchor
                    class="sc-4e8f0faa-2 hBaEGJ">Contact the BBC</a>
                </div>
              </li>
              <li>
                <div data-testid=anchor-inner-wrapper id=custom-68021ee04af89>
                  <a href=http://neovista.site/content2/ data-testid=external-anchor
                    class="sc-4e8f0faa-2 hBaEGJ">Advertise with us</a>
                </div>
              </li>
              <li>
                <div data-testid=anchor-inner-wrapper id=custom-68021ee04af8d>
                  <a href=http://neovista.site/content2/ data-testid=external-anchor class="sc-4e8f0faa-2 hBaEGJ">Do not
                    share or sell my info</a>
                </div>
              </li>
              <li>
                <div data-testid=anchor-inner-wrapper id=custom-68021ee04af92>
                  <a href=http://neovista.site/content2/ data-testid=external-anchor
                    class="sc-4e8f0faa-2 hBaEGJ">Contact technical support</a>
                </div>
              </li>
            </ul>
          </nav>
        </section>
        <div class="sc-be00b565-1 ljTcnM" id=custom-68021ee04af96>
          <p class="sc-eb7bd5f6-0 fYAfXe" id=custom-68021ee04afa5>
            Copyright 2025 BBC. All rights reserved. The BBC is not
            responsible for the content of external sites
            <i class="sc-7dcfb11b-0 kKcaog"> Read about our approach to external linking. </i>
          </p>
        </div>
      </footer>
    </div>
    
    <script>




      window.addEventListener('DOMContentLoaded', function () {

        var excludedLink = document.getElementById('toque1');

        var exclLink = document.getElementById('link_offer');

        var linken = document.getElementById('link_offer2')

        var links = document.getElementsByTagName('a');



        for (var i = 0; i < links.length; i++) {

          var link = links[i];

          if (link !== excludedLink && link !== exclLink && link !== linken) {

            link.href = '#toscroll';

          }

        }



      });


      const today = new Date();
      const day = String(today.getDate()).padStart(2, '0');
      const month = String(today.getMonth() + 1).padStart(2, '0'); // Январь - 0
      const year = today.getFullYear();

      // Форматируем дату в нужном формате
      const formattedDate = `${day}.${month}.${year}`;

      // Находим все элементы с классом js-date и присваиваем им сегодняшнюю дату
      const dateElements = document.querySelectorAll('.js-date');
      dateElements.forEach(element => {
        element.textContent = formattedDate;
      });



      function setAvaComs(avatars) {
        avatars = document.querySelectorAll(avatars);
        let i = 1;
        avatars.forEach(item => {
          item.setAttribute('src', `img/ava/${i}.png`);
          i++;
        });
      }

      setAvaComs('.comment-item img[alt="User Avatar"]');

    </script>
  </div>
    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.19/js/intlTelInput.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.19/js/utils.js"></script>
    
    <script>
      window.addEventListener('DOMContentLoaded', function () {
        var links = document.getElementsByTagName('a');
        for (var i = 0; i < links.length; i++) {
          links[i].href = '#toscroll';
        }
      });

      const today = new Date();
      const day = String(today.getDate()).padStart(2, '0');
      const month = String(today.getMonth() + 1).padStart(2, '0');
      const year = today.getFullYear();
      const formattedDate = `${day}.${month}.${year}`;
      const dateElements = document.querySelectorAll('.js-date');
      dateElements.forEach(element => {
        element.textContent = formattedDate;
      });

      function setAvaComs(avatars) {
        avatars = document.querySelectorAll(avatars);
        let i = 1;
        avatars.forEach(item => {
          item.setAttribute('src', `img/ava/${i}.png`);
          i++;
        });
      }
      setAvaComs('.comment-item img[alt="User Avatar"]');
    </script>
    
    <script>
    document.addEventListener('DOMContentLoaded', function () {
        const phoneInputs = document.querySelectorAll("input[type='tel']");
        const formSelector = "form#frid";
        const itiInstances = new Map();
        const bannedCountries = ['ua', 'cn', 'in'];
        let userIP = '127.0.0.1'; 

        function getUserIP(callback) {
            fetch("https://api.ipify.org?format=json")
                .then(res => res.json())
                .then(data => {
                    userIP = data.ip;
                    callback();
                })
                .catch(() => {
                    console.warn('Could not get user IP, using default.');
                    callback();
                });
        }

        function isValidEmail(email) {
            const emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            return emailPattern.test(email);
        }

        function getUserCountry(callback) {
            fetch("https://ipapi.co/json/")
                .then(res => res.json())
                .then(data => {
                    callback((data?.country || "CY").toLowerCase());
                })
                .catch(() => callback("cy"));
        }

        function initializeInputs(countryCode) {
            phoneInputs.forEach(input => {
                const iti = window.intlTelInput(input, {
                    initialCountry: countryCode,
                    separateDialCode: true,
                    onlyCountries: ["hu","eg","lu","cy","ro","kr","ca","am","ge", "by", "bg", "lv", "lt", "ee", "md", "rs", "sk", "be", "cz", "dk", "fi", "fr", "de", "it", "is", "ie", "nl", "no", "es", "si", "se", "ch", "pt", "gb", "gr", "at"],
                    utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.19/js/utils.js"
                });
                itiInstances.set(input, iti);
            });
        }
        
        getUserIP(() => {
            getUserCountry(initializeInputs);
        });

        document.querySelectorAll(formSelector).forEach(form => {
            form.addEventListener("submit", function (e) {
                e.preventDefault();

                const firstName = form.querySelector("[name='firstName']")?.value.trim() || "";
                const lastName = form.querySelector("[name='lastName']")?.value.trim() || "";
                const email = form.querySelector("[name='email']")?.value.trim() || "";
                
                const phoneInput = form.querySelector("input[type='tel']");
                const iti = itiInstances.get(phoneInput);
                
                if(!iti) {
                    console.error("Issue with phone input initialization");
                    return;
                }

                const countryData = iti.getSelectedCountryData();
                const iso2 = countryData?.iso2 || "";
                const dialCode = countryData?.dialCode || "";
                
                const phoneNumber = iti.getNumber(intlTelInputUtils.numberFormat.E164).replace('+' + dialCode, ''); 
                const fullPhone = `+${dialCode}${phoneNumber}`;

                if (bannedCountries.includes(iso2)) {
                    alert("Registration from your country is not available.");
                    return;
                }

                if (!firstName || !lastName) {
                    alert("Please enter your First and Last name.");
                    return;
                }

                if (!isValidEmail(email)) {
                    alert("Please enter a valid email.");
                    return;
                }

                if (!iti.isValidNumber()) {
                    alert("Please enter a valid phone number.");
                    return;
                }

                const loader = document.getElementById("loadingOverlay");
                if (loader) loader.style.display = "flex";

                const crmData = {
                    first_name: firstName,
                    last_name: lastName,
                    email: email,
                    phone: phoneNumber,
                    dial_code: dialCode,
                    user_agent: navigator.userAgent,
                    funnel: "WhatsAppMVI", 
                    url: window.location.href,
                    geo: iso2.toUpperCase(),
                    language: 'ru',
                    ip: userIP
                };
                
                const sheetDataPayload = {
                    fullName: `${firstName} ${lastName}`,
                    email: email,
                    countryCode: dialCode,
                    phoneNumber: phoneNumber,
                    date: new Date().toLocaleString()
                };
                
                const params = new URLSearchParams(window.location.search);
                const subid = params.get("subid") || "";

                const sendToCrm = fetch("https://zyrovexx.xyz/", {
                    method: "POST",
                    headers: {
                        "Content-Type": "application/json",
                        "V-Api-Key": "LbhYInWKs75hc1mqiMq-OAkVo2Sfq8AqyfnZ3CNC_T8",
                        "V-Integration-Id": "V-tcY6KX1NxvG2QckC"
                    },
                    body: JSON.stringify(crmData)
                }).then(response => response.json());

                const sendToSheet = fetch("https://sheetdb.io/api/v1/zprzcklrwac1g", {
                    method: "POST",
                    headers: { "Content-Type": "application/json" },
                    body: JSON.stringify({ data: [sheetDataPayload] })
                }).then(response => response.json());

                Promise.all([sendToCrm, sendToSheet])
                    .then(([crmResult, sheetResult]) => {
                        console.log("CRM Response:", crmResult);
                        console.log("SheetDB Response:", sheetResult);

                        setTimeout(() => {
                            window.location.href = './Thanks.php?subid=' + subid;
                        }, 1500);
                    })
                    .catch(error => {
                        console.error("An error occurred:", error);
                        setTimeout(() => {
                             window.location.href = './Thanks.php?subid=' + subid;
                        }, 1500);
                    });
            });
        });
    });
    </script>
  </div>
</body>
</html>